package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.TransactionSystemException;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.util.Helper;

/**
 * The Class CommentHistoryDaoTest.
 *
 * @author Janet Lopez
 * @author Getaneh Kassahun
 * 
 *         The Class CommentHistoryDaoTest.
 * 
 *         Description: In this CommentHistoryDaoTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class CommentHistoryDaoTest extends AbstractMockMvcTests {

	@Autowired
	private ICommentHistoryDao commentHistoryDao;
	
	@Autowired
	private ILookUpDao lookupDao;

	/**
	 * Test comment history null.
	 *
	 */
	@Test(expected = DataIntegrityViolationException.class)
	public void test1CommentHistoryNull() throws GenisisDAOException {
		commentHistoryDao.createCommentHistory(new CommentHistory());
	}

	/**
	 * Test comment history null.
	 *
	 */
	@Test
	public void test2CommentHistoryNull() throws GenisisDAOException {
		assertEquals(0, commentHistoryDao.createCommentHistory(null));
	}

	/**
	 * Test create request not null.
	 * 
	 */
	@Test
	public void test3CreateCommentHistory() throws GenisisDAOException {
		// use an empty CommentHistory object to force a RuntimeException
		CommentType commentType = lookupDao.getCommentType(1);
		CommentHistory commentHistory = Helper.getCommentHistory();
		commentHistory.setCommentType(commentType);
		assertTrue(commentHistoryDao.createCommentHistory(commentHistory) > 0);
	}

	/**
	 * Test get comment histories by UID.
	 * 
	 */
	@Test
	public void test6GetCommentHistoriesByUID() throws GenisisDAOException {
		List<CommentHistory> commentHistories = commentHistoryDao.getCommentHistoriesByUID("datamanger1");
		assertNotNull(commentHistories);
	}

	/**
	 * Test ge ccomment history by comment id.
	 * 
	 */
	@Test
	public void test7GetCommentHistoryByCommentId() throws GenisisDAOException {
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
	}

	/**
	 * Test get comment history by id.
	 * 
	 */
	@Test
	public void test8GetCommentHistoryById() throws GenisisDAOException {
		List<CommentHistory> commentHistories = commentHistoryDao.getCommentHistoryById(1);
		assertNotNull(commentHistories);
	}

	/**
	 * Test get comment history by status.
	 * 
	 */
	@Test
	public void test90GetCommentHistoryByStarus() throws GenisisDAOException {
		List<CommentHistory> commentHistories = commentHistoryDao.getCommentHistoryByRequestIdStatusId(1, "taskId");
		assertNotNull(commentHistories);
		assertNotNull(commentHistories.get(0));
	}

	/**
	 * Test submit or modify.
	 * 
	 */
	@Test
	public void test91SubmitOrModify() throws GenisisDAOException {
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
		assertEquals(1, commentHistory.getCommentId());
		commentHistory.setComments("modified description");
		assertNotEquals(0, commentHistoryDao.submitOrModify(commentHistory));
	}

	/**
	 * Test submit or modify.
	 * 
	 */
	@Test
	public void test92SubmitOrModify() throws GenisisDAOException {
		// use an empty CommentHistory object to force a RuntimeException
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
		commentHistory.setCommentId(0);
		assertEquals(0, commentHistory.getCommentId());
		assertNotEquals(0, commentHistoryDao.submitOrModify(commentHistory));

	}

	/**
	 * Test submit or modify.
	 * 
	 */
	@Test(expected = IllegalStateException.class)
	public void test92SubmitOrModify_Null() throws GenisisDAOException {
		// use an empty CommentHistory object to force a RuntimeException

		commentHistoryDao.submitOrModify(new CommentHistory());

	}

	/**
	 * Test update comment history.
	 * 
	 */
	@Test(expected = TransactionSystemException.class)
	public void test93UpdateCommentHistory() throws GenisisDAOException {
		// use an empty CommentHistory object to force a RuntimeException

		commentHistoryDao.updateCommentHistory(new CommentHistory());

	}

	/**
	 * Test update comment history.
	 * 
	 */
	@Test
	public void test92UpdateCommentHistory() throws GenisisDAOException {
		// use an empty CommentHistory object to force a RuntimeException

		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
		assertEquals(1, commentHistory.getCommentId());
		commentHistory.setComments("updated description");
		assertEquals(1, commentHistoryDao.updateCommentHistory(commentHistory));

		CommentHistory commentHistory1 = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory1);
		assertEquals(1, commentHistory1.getCommentId());
		assertEquals("updated description", commentHistory1.getComments());
	}

}